class Enemy_Spinner expands Enemy;

#exec mesh IMPORT MESH=Spinner ANIVFILE=Models\Enemies\Spinner\Spinner_a.3d DATAFILE=Models\Enemies\Spinner\Spinner_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=Spinner X=0 Y=0 Z=112 YAW=-64

#exec MESH SEQUENCE MESH=Spinner SEQ=All      STARTFRAME=0 NUMFRAMES=183
#exec MESH SEQUENCE MESH=Spinner SEQ=death    STARTFRAME=0 NUMFRAMES=20
#exec MESH SEQUENCE MESH=Spinner SEQ=bite     STARTFRAME=20 NUMFRAMES=17 Group=Attack
#exec MESH SEQUENCE MESH=Spinner SEQ=backstep STARTFRAME=37 NUMFRAMES=9
#exec MESH SEQUENCE MESH=Spinner SEQ=idle     STARTFRAME=46 NUMFRAMES=19
#exec MESH SEQUENCE MESH=Spinner SEQ=jump     STARTFRAME=65 NUMFRAMES=16
#exec MESH SEQUENCE MESH=Spinner SEQ=look     STARTFRAME=81 NUMFRAMES=26
#exec MESH SEQUENCE MESH=Spinner SEQ=run      STARTFRAME=107 NUMFRAMES=10
#exec MESH SEQUENCE MESH=Spinner SEQ=threat   STARTFRAME=117 NUMFRAMES=17
#exec MESH SEQUENCE MESH=Spinner SEQ=walk     STARTFRAME=134 NUMFRAMES=16
#exec MESH SEQUENCE MESH=Spinner SEQ=wound    STARTFRAME=150 NUMFRAMES=11
#exec MESH SEQUENCE MESH=Spinner SEQ=zap      STARTFRAME=160 NUMFRAMES=23 Group=Attack
#exec MESH SEQUENCE MESH=Spinner SEQ=jumpbite STARTFRAME=183 NUMFRAMES=17 Group=MovingAttack
#exec MESH SEQUENCE MESH=Spinner SEQ=runbite  STARTFRAME=200 NUMFRAMES=10 Group=MovingAttack

#exec texture IMPORT NAME=JSpinner1 FILE=Textures\Enemies\Spinner\JSpinner1.bmp GROUP=Skins FLAGS=2 // spidxLEG3
#exec texture IMPORT NAME=JSpinner2 FILE=Textures\Enemies\Spinner\JSpinner2.bmp GROUP=Skins PALETTE=JSpinner1 // spidx2map6

#exec MESH NOTIFY MESH=Spinner SEQ=bite          TIME=0.50 FUNCTION=BiteDamageTarget
#exec MESH NOTIFY MESH=Spinner SEQ=jumpbite      TIME=0.50 FUNCTION=BiteDamageTarget
#exec MESH NOTIFY MESH=Spinner SEQ=runbite       TIME=0.50 FUNCTION=BiteDamageTarget
#exec MESH NOTIFY MESH=Spinner SEQ=runbite       TIME=0.00 FUNCTION=RunStep
#exec MESH NOTIFY MESH=Spinner SEQ=runbite       TIME=0.60 FUNCTION=RunStep
#exec MESH NOTIFY MESH=Spinner SEQ=run           TIME=0.00 FUNCTION=RunStep
#exec MESH NOTIFY MESH=Spinner SEQ=run           TIME=0.50 FUNCTION=RunStep
#exec MESH NOTIFY MESH=Spinner SEQ=walk          TIME=0.43 FUNCTION=WalkStep
#exec MESH NOTIFY MESH=Spinner SEQ=walk          TIME=0.93 FUNCTION=WalkStep
//#exec MESH NOTIFY MESH=Spinner SEQ=zap           TIME=0.33 FUNCTION=SpawnShot
//#exec MESH NOTIFY MESH=Spinner SEQ=zap           TIME=0.67 FUNCTION=SpawnShot
#exec MESH NOTIFY MESH=Spinner SEQ=zap           TIME=0.50 FUNCTION=SpawnShot

#exec MESHMAP NEW   MESHMAP=Spinner MESH=Spinner
#exec MESHMAP SCALE MESHMAP=Spinner X=0.1 Y=0.1 Z=0.2

#exec MESHMAP SETTEXTURE MESHMAP=Spinner NUM=0 TEXTURE=JSpinner1
#exec MESHMAP SETTEXTURE MESHMAP=Spinner NUM=1 TEXTURE=JSpinner2

#exec AUDIO IMPORT FILE="Sounds\Enemies\Spinner\amb1.wav"   NAME="amb1"   GROUP="Spinner"
#exec AUDIO IMPORT FILE="Sounds\Enemies\Spinner\amb2.wav"   NAME="amb2"   GROUP="Spinner"
#exec AUDIO IMPORT FILE="Sounds\Enemies\Spinner\bite.wav"    NAME="bite"   GROUP="Spinner"
#exec AUDIO IMPORT FILE="Sounds\Enemies\Spinner\die1.wav"  NAME="die1"   GROUP="Spinner"
#exec AUDIO IMPORT FILE="Sounds\Enemies\Spinner\die2.wav"  NAME="die2"   GROUP="Spinner"
//#exec AUDIO IMPORT FILE="Sounds\Enemies\Spinner\spinstep1.wav"   NAME="step1"  GROUP="Spinner"
//#exec AUDIO IMPORT FILE="Sounds\Enemies\Spinner\spinstep2.wav"   NAME="step2"  GROUP="Spinner"
//#exec AUDIO IMPORT FILE="Sounds\Enemies\Spinner\spinstep3.wav"   NAME="step3"  GROUP="Spinner"
#exec AUDIO IMPORT FILE="Sounds\Enemies\Spinner\Hurt1.wav"   NAME="hurt1"   GROUP="Spinner"
#exec AUDIO IMPORT FILE="Sounds\Enemies\Spinner\Hurt2.wav"   NAME="hurt2"   GROUP="Spinner"
#exec AUDIO IMPORT FILE="Sounds\Enemies\Spinner\Hurt3.wav"   NAME="hurt3"   GROUP="Spinner"
#exec AUDIO IMPORT FILE="Sounds\Enemies\Spinner\Threat1.wav" NAME="threat1" GROUP="Spinner"
#exec AUDIO IMPORT FILE="Sounds\Enemies\Spinner\Threat2.wav" NAME="threat2" GROUP="Spinner"
#exec AUDIO IMPORT FILE="Sounds\Enemies\Spinner\Threat3.wav" NAME="threat3" GROUP="Spinner"

var() byte BiteDamage;	// Basic damage done by bite.

var(Sounds) sound Bite;
var(Sounds) sound Die2;
var(Sounds) sound Footstep;
var(Sounds) sound Footstep2;

//
// Animation functions
//

function PlayRunning()
{
	PlayAnim( 'run' );
	// TODO: Strafing?
}

function PlayWalking()
{
	PlayAnim( 'walk' );
}

function PlayWaiting()
{
	local float AnimSpeed;
	AnimSpeed = 0.3 + 0.6 * FRand(); //vary speed
	if( FRand() < 0.05 )
	{
		SetAlertness( 0.5 );
		PlayAnim( 'look', AnimSpeed, 0.2 );
	}
	else
	{
		SetAlertness( 0.0 );
		PlayAnim( 'idle', AnimSpeed, 0.2 );
	}
}

function PlayTurning()
{
	//PlayAnim( 'walk', 1.0, 0.1 );
	//TweenAnim( 'walk', 0.2 );
	LoopAnim( 'walk', 1.0, 0.2 );
}

function PlayThreatening()
{
	local float decision, AnimSpeed;

	decision = FRand();
	AnimSpeed = 0.4 + 0.6 * FRand();

	if( decision < 0.7 )
	{
		PlayAnim( 'threat', AnimSpeed, 0.3 );
	}
	else if( decision < 0.9 )
	{
		PlayAnim( 'idle', AnimSpeed * 2, 0.3 );
	}
	else
	{
		PlayAnim( 'look', AnimSpeed, 0.3 );
	}
}

function PlayChallenge()
{
	PlayThreatening();
}

function PlayMeleeAttack()
{
	PlayAnim( 'bite' );
}

function PlayMovingAttack()
{
	PlayAnim( 'runbite' );
}

function PlayRangedAttack()
{
	PlayAnim( 'zap' );
}

function PlayGutHit( float tweentime )
{
	PlayAnim( 'wound' );
}

function PlayHeadHit( float tweentime )
{
	PlayAnim( 'wound' );
}

function PlayLeftHit( float tweentime )
{
	PlayAnim( 'wound' );
}

function PlayRightHit( float tweentime )
{
	PlayAnim( 'wound' );
}

function PlayBigDeath( name DamageType )
{
	PlayAnim( 'death' );
	PlaySound( Die2, SLOT_Talk, 4.5 * TransientSoundVolume );
}

function PlayHeadDeath( name DamageType )
{
	PlayAnim( 'death' );
	PlaySound( Die, SLOT_Talk, 4.5 * TransientSoundVolume );
}

function PlayLeftDeath( name DamageType )
{
	PlayAnim( 'death' );
	PlaySound( Die, SLOT_Talk, 4.5 * TransientSoundVolume );
}

function PlayRightDeath( name DamageType )
{
	PlayAnim( 'death' );
	PlaySound( Die, SLOT_Talk, 4.5 * TransientSoundVolume );
}

function PlayGutDeath( name DamageType )
{
	PlayAnim( 'death' );
	PlaySound( Die, SLOT_Talk, 4.5 * TransientSoundVolume );
}

function TweenToRunning( float tweentime )
{
	TweenAnim( 'run', tweentime );
}

function TweenToWalking( float tweentime )
{
	TweenAnim( 'walk', tweentime );
}

function TweenToWaiting( float tweentime )
{
	TweenAnim( 'idle', tweentime );
}

function PlayTakeHitSound( int Damage, name damageType, int Mult )
{
	local float decision;

	if( Level.TimeSeconds - LastPainSound < 0.25 )
		return;
	LastPainSound = Level.TimeSeconds;

	if( FRand() < 0.5 )
	{
		PlaySound( HitSound1, SLOT_Pain, 2.0 * Mult );
	}
	else
	{
		PlaySound( HitSound2, SLOT_Pain, 2.0 * Mult );
	}
}


//
// Notify functions
//

function RunStep()
{
	if( FRand() < 0.6 )
		PlaySound( FootStep, SLOT_Interact, 0.8,, 900 );
	else
		PlaySound( FootStep2, SLOT_Interact, 0.8,, 900 );
}

function WalkStep()
{
	if( FRand() < 0.6 )
		PlaySound( FootStep, SLOT_Interact, 0.2,, 500 );
	else
		PlaySound( FootStep2, SLOT_Interact, 0.2,, 500 );
}

function BiteDamageTarget()
{
	if( MeleeDamageTarget( BiteDamage, BiteDamage * 1000 * Normal( Target.Location - Location ) ) )
		PlaySound( Bite, SLOT_Interact );
}

function SpawnShot()
{
	local rotator FireRotation;
	local vector X,Y,Z, projStart;

	GetAxes( Rotation, X, Y, Z );
	MakeNoise( 1.0 );
	projStart = Location + 1.1 * CollisionRadius * X + 0.4 * CollisionHeight * Z;
	FireRotation = AdjustToss( ProjectileSpeed, projStart, 200, bLeadTarget, bWarnTarget );
	spawn( RangedProjectile, self,'', projStart, FireRotation );
}


//
// Miscellaneous functions
//

function SetMovementPhysics()
{
	SetPhysics( PHYS_Falling );
}

function bool CanFireAtEnemy()
{
	local vector HitLocation, HitNormal, EnemyDir, EnemyUp;
	local actor HitActor;
	local float EnemyDist;

	EnemyDir = Enemy.Location - Location;
	EnemyDist = VSize( EnemyDir );
	EnemyUp = Enemy.CollisionHeight * vect(0,0,0.9);

	//log( Self $ " CanFireAtEnemy() EnemyDir " $ rotator(EnemyDir) $ " EnemyDist " $ EnemyDist $ " EnemyUp " $ EnemyUp.Z );

	if( EnemyDist > 640 )
	{
		//log( Self $ " CanFireAtEnemy() EnemyDist > 640, return false" );
		return false;
	}
	if( EnemyDist > 300 )
	{
		EnemyDir = 300 * EnemyDir / EnemyDist;
		EnemyUp = 300 * EnemyUp / EnemyDist;
	}

	HitActor = Trace( HitLocation, HitNormal, Location + EnemyDir + EnemyUp, Location, true );

	if( HitActor == None || HitActor == Enemy || Pawn(HitActor) != None && AttitudeTo( Pawn(HitActor) ) <= ATTITUDE_Ignore )
		return true;

	HitActor = Trace( HitLocation, HitNormal, Location + EnemyDir, Location, true );

	return HitActor == None || HitActor == Enemy || Pawn(HitActor) != None && AttitudeTo( Pawn(HitActor) ) <= ATTITUDE_Ignore;
}


//
// Aiming functions
//

function rotator AdjustToss( float ProjSpeed, vector ProjStart, int AimError, bool LeadTarget, bool WarnTarget )
{
	local rotator FireRotation;
	local vector FireSpot;
	local actor HitActor;
	local vector HitLocation, HitNormal;
	local float TargetDist, TossSpeed, TossTime;

	if( projSpeed == 0 )
		return AdjustAim( projSpeed, projStart, aimerror, leadTarget, warnTarget );
	if( Target == None )
		Target = Enemy;
	if( Target == None )
		return Rotation;
	if( !Target.IsA('Pawn') )
		return rotator( Target.Location - Location );

	FireSpot = Target.Location;
	TargetDist = VSize( Target.Location - ProjStart );
	//AimError = AimError * ( 11 - 10 *
	//	( ( Target.Location - Location ) / TargetDist
	//		Dot Normal( ( Target.Location + 0.7 * Target.Velocity ) - ( ProjStart + 0.7 * Velocity ) ) ) );

	//AimError = AimError * (2.6 - 0.65 * (skill + FRand()));
	//if ( (Skill < 2) && (Level.TimeSeconds - LastPainTime < 0.15) )
	//	aimerror *= 1.3;

	if ( leadTarget )
	{
		FireSpot += FMin( 1, 0.7 + 0.6 * FRand() ) * ( Target.Velocity * TargetDist / ProjSpeed );
		HitActor = Trace( HitLocation, HitNormal, FireSpot, ProjStart, false );
		if( HitActor != None )
		{
			FireSpot = 0.5 * ( FireSpot + Target.Location );
		}
	}

	//try middle
	FireSpot.Z = Target.Location.Z;
	HitActor = Trace( HitLocation, HitNormal, FireSpot, ProjStart, false );

	if ( HitActor != None && Target == Enemy )
	{
		FireSpot = LastSeenPos;
		if( Location.Z >= LastSeenPos.Z )
		{
			FireSpot.Z -= 0.5 * Enemy.CollisionHeight;
		}
	}

	// adjust for toss distance (assume 200 z velocity add & 60 init height)
	if( FRand() < 0.90 )
	{
		TossSpeed = ProjSpeed + 0.4 * VSize( Velocity );
		if( Region.Zone.ZoneGravity.Z != Region.Zone.Default.ZoneGravity.Z || TargetDist > TossSpeed )
		{
			TossTime = TargetDist / TossSpeed;
			FireSpot.Z -= ( ( 0.25 * Region.Zone.ZoneGravity.Z * TossTime + 200 ) * TossTime + 0.4 * CollisionHeight );
		}
	}

	FireRotation = Rotator( FireSpot - ProjStart );

	FireRotation.Yaw = FireRotation.Yaw + ( Rand(2 * AimError) - AimError );
	if( WarnTarget && Pawn(Target) != None )
		Pawn(Target).WarnTarget( self, ProjSpeed, Vector(FireRotation) );

	FireRotation.Yaw = FireRotation.Yaw & 65535;
	if( Abs( FireRotation.Yaw - ( Rotation.Yaw & 65535 ) ) > 8192 &&
		Abs( FireRotation.Yaw - ( Rotation.Yaw & 65535 ) ) < 57343 )
	{
		if( FireRotation.Yaw > Rotation.Yaw + 32768 ||
			FireRotation.Yaw < Rotation.Yaw && FireRotation.Yaw > Rotation.Yaw - 32768 )
		{
			FireRotation.Yaw = Rotation.Yaw - 8192;
		}
		else
		{
			FireRotation.Yaw = Rotation.Yaw + 8192;
		}
	}
	ViewRotation = FireRotation;
	return FireRotation;
}


//
// States
//

auto state StartUp
{
	function SetFall()
	{
	}
	function SetMovementPhysics()
	{
		SetPhysics( PHYS_None ); // don't fall at start
	}
//Begin:
//	log( Self $ " StartUp Rotation " $ Rotation $ " DesiredRotation " $ DesiredRotation );
}

state Waiting
{
TurnFromWall:
	if( NearWall(70) )
	{
		PlayTurning();
		TurnTo( Focus );
	}
Begin:
	TweenToWaiting( 0.4 );
	bReadyToAttack = false;
	if( Physics != PHYS_Falling )
	{
		SetPhysics( PHYS_None );
	}
KeepWaiting:
	NextAnim = '';
}

defaultproperties
{
    HUDname="Spinner"
	HUDcolor=(R=255,G=0,B=0)
    BiteDamage=20
    Bite=Sound'Bite'
    Die2=Sound'Die2'
    footstep=Sound'UnrealI.Pupae.scuttle1pp'
    Footstep2=Sound'UnrealI.Pupae.scuttle1pp'
    CarcassType=Class'Carcass_Spinner'
    TimeBetweenAttacks=3.50
    Aggressiveness=0.80
    bHasRangedAttack=True
    bGreenBlood=True
    RangedProjectile=Class'UnrealShare.SlithProjectile'
    ProjectileSpeed=900.00
    Acquire=Sound'amb1'
    Fear=Sound'amb2'
    Roam=Sound'threat2'
    Threaten=Sound'threat3'
    bCanStrafe=True
    MeleeRange=60.00
    GroundSpeed=250.00
    AccelRate=500.00
    JumpZ=128.00
    Health=100
    HitSound1=Sound'Hit'
    HitSound2=Sound'hurt3'
    Die=Sound'Die1'
    CombatStyle=0.60
    MenuName="Spinner"
    AmbientSound=Sound'amb1'
    DrawType=2
    Mesh=LodMesh'Spinner'
    DrawScale=1.10
    CollisionRadius=32.00
    Buoyancy=100.00
    RotationRate=(Pitch=3072,Yaw=50000,Roll=3072),
}
